#!/usr/bin/bash

file="/etc/tgb/tgbtun.params"
logfile="/var/log/thegreenbow/$(date '+%Y-%m-%d')-tgbiked.log"
logdate="$(date '+%Y-%m-%d %H:%M:%S')    "

if [ ! -f "$file" ]; then
	echo "$logdate missing tgbtun.params in /etc/tgb" >> $logfile
	exit 0
fi

re="^kernel-requires=.*$"
kr=$(cat $file | grep "$re" | sed -E 's/^kernel-requires=//')

if [ -z "$kr" ]; then
	echo "$logdate kernel-requires not found or empty" >> $logfile
	exit 0
fi

kernel=$(uname -r)

echo "$logdate using kernel version $kernel, requires kernel version $kr" >> $logfile

if [ -z `echo $kernel | grep -E "$kr"` ]; then
	echo "$logdate unsupported kernel, kernel version mismatch (actual: '$kernel', required: '$kr')" >> $logfile
	exit 0
fi

echo "$logdate supported kernel, kernel version match (actual: '$kernel', required: '$kr')" >> $logfile

echo "$logdate running modprobe tgbtun" >> $logfile
modprobe tgbtun

exit 0
