/**
 * @file debug.h
 * @author TheGreenBow (support@thegreenbow.com)
 * @brief 
 * @version 0.1
 * @date 2020-12-16
 * 
 * @copyright Copyright (c) 2020
 * 
 */

#ifndef DEBUG_H
#define DEBUG_H

#include <linux/kernel.h>

static inline void dump_packet(uint8_t *pkt, size_t len) {
    #ifdef DEBUG
    uint8_t *it;
    uint8_t *tail = pkt + len;
    for(it = pkt; it != tail ; ++it) {
        printk(KERN_CONT "%02x ", *pkt);
        ++pkt;
    }
    #endif
}

#endif //DEBUG_H