/**
 * @file netfilter.c
 * @author TheGreenBow (support@thegreenbow.com)
 * @copyright Copyright (c) 2025
 */

#include "receive.h"

#include <linux/skbuff.h>
#include <linux/ip.h>
#include <linux/inet.h>

#include "frame_utils.h"
#include "private_api.h"
#include "debug.h"

extern struct net_device* tgbtun;  // net device used

bool tgb13e0a64be66f7915e12c8e533e09d07d1b0550485b85aca789bf7548b8a3ae96(struct sk_buff* skb)
{
    unsigned int status;

    skb_push(skb, sizeof(struct ethhdr));  // add data to the start of a buffer
    status = p_api_frame_decrypt(eth_hdr(skb)->h_dest, htons(ip_hdr(skb)->tot_len) + ETH_HLEN);

    if (unlikely(status == 0))
    {
        #ifdef DEBUG
        printk(KERN_ERR, "tgbtun: decryption failure on incoming ESP packet\n");
        #endif 
        return false;
    }
    return true;
}

bool tgbf8beea5b4669558b1605de79eb9ecb71bc4cfbf26db82e8a22da1c68fa702d70(uint8_t* frame, const uint32_t size)
{
    struct sk_buff *skb, *trailer;

   // dump_packet(frame, size);
    skb = alloc_skb(size + ETH_HLEN + 2, GFP_ATOMIC);
    if (unlikely(!skb))
        goto drop;

    memcpy(skb_put(skb, size), frame, size);
    kfree(frame);  // free buffer get from ipseclib

    skb->dev = tgbtun;
    skb->protocol = eth_type_trans(skb, tgbtun);
    skb->pkt_type = PACKET_HOST;
    skb->ip_summed = CHECKSUM_UNNECESSARY;
    tgbtun->stats.rx_packets++;
    tgbtun->stats.rx_bytes += size;
    skb_data_align(skb, 1, &trailer);
    if (unlikely(netif_receive_skb(skb) == NET_RX_DROP))
    {
        goto drop;
    }

    return true;

drop:
    tgbtun->stats.rx_dropped++;
    pr_err("tgbtun: packet dropped\n");
    return false;
}